-- TelePet schema (MySQL)
CREATE TABLE IF NOT EXISTS users(
  id BIGINT PRIMARY KEY,
  name VARCHAR(100) DEFAULT '',
  username VARCHAR(50) DEFAULT '',
  coins BIGINT DEFAULT 0,
  pet_level INT DEFAULT 1,
  boost_until BIGINT DEFAULT 0,
  referred_by BIGINT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_seen DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX(referred_by)
);

CREATE TABLE IF NOT EXISTS coin_logs(
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id BIGINT,
  amount INT,
  reason VARCHAR(32),
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  INDEX(user_id)
);

CREATE TABLE IF NOT EXISTS daily_claims(
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id BIGINT,
  day DATE,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_day (user_id, day)
);

CREATE TABLE IF NOT EXISTS quizzes(
  id INT AUTO_INCREMENT PRIMARY KEY,
  question VARCHAR(255),
  options JSON,
  correct INT,
  reward INT DEFAULT 20
);

CREATE TABLE IF NOT EXISTS quiz_answers(
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id BIGINT,
  quiz_id INT,
  choice INT,
  correct TINYINT(1),
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  INDEX(user_id), INDEX(quiz_id)
);

-- Seed quizzes
INSERT INTO quizzes(question, options, correct, reward) VALUES
('Con chó sủa “gâu gâu” tiếng Anh là?', JSON_ARRAY('meow','bark','quack','oink'), 1, 25),
('1 + 2 x 3 = ?', JSON_ARRAY('9','7','6','5'), 1, 20),
('Trái đất quay quanh?', JSON_ARRAY('Mặt trăng','Mặt trời','Sao Hỏa','Sao Kim'), 1, 25);
