<?php
if (!isset($page_title)) $page_title = "MiniApp Game";
?>
<!doctype html>
<html lang="vi">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($page_title) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="../assets/css/app.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
</head>
<body>
<header class="app-header d-flex justify-content-between align-items-center px-3 py-2 shadow-sm">
  <div class="d-flex align-items-center gap-2">
    <div class="avatar">👤</div>
    <div class="fw-bold username"><?= isset($user['name']) ? htmlspecialchars($user['name']) : 'Khách' ?></div>
  </div>
  <div class="d-flex align-items-center">
    <div class="balance me-2"><span class="coin">🪙</span> <span id="userBalance"><?= isset($user['balance']) ? $user['balance'] : 0 ?></span></div>
    <i id="musicToggle" class="bi bi-music-note-beamed" title="Bật/Tắt nhạc"></i>
  </div>
</header>
<main class="app-main container py-3">