<?php 
require_once __DIR__.'/../config.php'; 
?>
<!doctype html>
<html lang="vi" data-theme="dark">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>TelePet Clicker - Bảng xếp hạng Coins</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/app.css">
  <script src="https://telegram.org/js/telegram-web-app.js"></script>
  <style>
  body { 
    background: radial-gradient(1200px 600px at 20% -20%, #3e1f72, transparent), 
                radial-gradient(1200px 800px at 120% 20%, #0b6b6e, transparent), 
                #0c0e14; 
    color: #f3f4f6; 
  }
  table thead { background: rgba(255,255,255,0.1); }
  </style>
</head>
<body class="bg-body">

<div id="main-app" class="container py-3">

  <!-- HEADER -->
  <div class="d-flex align-items-center gap-3 mb-3">
    <img src="https://cdn.jsdelivr.net/gh/twitter/twemoji@14.0.2/assets/svg/1f436.svg" width="48" height="48" alt="coins">
    <div>
      <h4 class="m-0 fw-bold">TelePet Clicker</h4>
      <small class="text-secondary">Bảng xếp hạng • Coins</small>
    </div>
    <div class="ms-auto">
      <span id="username" class="badge text-bg-secondary">...</span>
    </div>
  </div>

  <!-- BẢNG XẾP HẠNG -->
  <h4 class="mb-3">🏆 Bảng xếp hạng Coins</h4>
  
  <div class="card glass mb-3">
    <div class="card-body">
      <table class="table table-dark table-striped align-middle text-center">
        <thead>
          <tr>
            <th>#</th>
            <th>Người chơi</th>
            <th>Coins</th>
          </tr>
        </thead>
        <tbody id="rank-body">
          <tr><td colspan="3">Đang tải...</td></tr>
        </tbody>
      </table>
    </div>
  </div>

</div>

<?php include 'footer.php'; ?>

<script>
const API = 'api.php';

function getInitData(){
  const tg = window.Telegram?.WebApp;
  if(!tg) return null;
  return { user: tg.initDataUnsafe?.user || null };
}

async function api(action){
  const init = getInitData();
  const body = new URLSearchParams({ 
    action, 
    init_data: JSON.stringify({ user: init?.user || {} }) 
  });
  const r = await fetch(API, { method: 'POST', body });
  return r.json();
}

function setUserUI(u){
  document.getElementById('username').textContent = u.name || 'Ẩn danh';
}

function renderRank(list){
  const body = document.getElementById('rank-body');
  body.innerHTML = '';
  if(!list || list.length === 0){
    body.innerHTML = '<tr><td colspan="3">Chưa có dữ liệu</td></tr>';
    return;
  }
  list.forEach((u,i)=>{
    body.innerHTML += `
      <tr>
        <td>${i+1}</td>
        <td>${u.name || 'Ẩn danh'}</td>
        <td>${u.coins}</td>
      </tr>`;
  });
}

async function refreshMe(){
  const r = await api('me');
  if(r.ok) setUserUI(r.user);
}

async function loadRank(){
  const r = await api('rank');
  if(r.ok) renderRank(r.list);
}

document.addEventListener('DOMContentLoaded', ()=>{
  refreshMe();
  loadRank();
});
</script>

</body>
</html>
