<?php
require_once __DIR__.'/db.php';
require_once __DIR__.'/../config.php';

function now_ts(){ return time(); }

function json_ok($data=[]){ header('Content-Type: application/json'); echo json_encode(['ok'=>true]+$data); exit; }
function json_err($msg, $code=400){ http_response_code($code); header('Content-Type: application/json'); echo json_encode(['ok'=>false,'error'=>$msg]); exit; }

function user_get($pdo, $uid){
    $st=$pdo->prepare("SELECT * FROM users WHERE id=?"); $st->execute([$uid]); return $st->fetch();
}
function add_coins($pdo, $uid, $amount, $reason='tap'){
    $amount = intval($amount);
    if($amount==0) return;
    $pdo->prepare("UPDATE users SET coins=coins+:a WHERE id=:id")->execute([':a'=>$amount,':id'=>$uid]);
    $pdo->prepare("INSERT INTO coin_logs (user_id, amount, reason, created_at) VALUES (:u,:a,:r, NOW())")
        ->execute([':u'=>$uid,':a'=>$amount,':r'=>$reason]);
}
function grant_daily($pdo,$uid){
    // 1 claim per calendar day
    $today = date('Y-m-d');
    $st = $pdo->prepare("SELECT COUNT(*) c FROM daily_claims WHERE user_id=? AND day=?");
    $st->execute([$uid,$today]);
    $c = (int)$st->fetch()['c'];
    if($c>0) return false;
    add_coins($pdo,$uid, DAILY_REWARD, 'daily');
    $pdo->prepare("INSERT INTO daily_claims (user_id, day, created_at) VALUES (?,?,NOW())")->execute([$uid,$today]);
    return true;
}
function start_boost($pdo, $uid){
    $until = time()+BOOST_DURATION_SEC;
    $pdo->prepare("UPDATE users SET boost_until = :u WHERE id=:id")->execute([':u'=>$until, ':id'=>$uid]);
    return $until;
}
function current_multiplier($user){
    $m = 1;
    if((int)$user['boost_until'] > time()) $m *= BOOST_MULTIPLIER;
    return $m;
}
function random_chest(){
    return rand(CHEST_MIN, CHEST_MAX);
}
function sign_token($data){
    $payload = base64_encode(json_encode($data));
    $sig = hash_hmac('sha256', $payload, APP_SECRET);
    return $payload.'.'.$sig;
}
function verify_token($token){
    $parts = explode('.', $token);
    if(count($parts)!=2) return false;
    list($payload,$sig) = $parts;
    $exp = hash_hmac('sha256',$payload, APP_SECRET);
    if(!hash_equals($exp,$sig)) return false;
    $data = json_decode(base64_decode($payload), true);
    return $data;
}
?>
